<?php


namespace Elementor;

use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;


if (!defined('ABSPATH')) exit;

class Epress_Countdown extends Widget_Base
{

    public $base;


    public function __construct($data = [], $args = null)
    {

        parent::__construct($data, $args);


        wp_register_style('count-css', \ElementPress::widgets_url() . '/epress-countdown/assets/css/countdown.css', false, \ElementPress::version);

        wp_register_script('epress-countdown-js', \ElementPress::widgets_url() . '/epress-countdown/assets/js/countdown.js', array('jquery'), \ElementPress::version, true);

        // add_action('elementor/editor/after_enqueue_scripts', function () {

        //     wp_register_script('epress-countdown-js', \ElementPress::widgets_url() . '/epress-countdown/assets/js/countdown.js', array('jquery'), \ElementPress::version, true);

        // });

    }

    /////////////////////////////////////////////////////////////////

    //Css Style file including function

    /////////////////////////////////////////////////////////////////

    public function get_style_depends()
    {


        return ['count-css'];

    }

    /////////////////////////////////////////////////////////////////

    //JS Functionality file including function

    /////////////////////////////////////////////////////////////////

    public function get_script_depends()
    {

        return [

            'epress-countdown-js',

        ];

    }

    /////////////////////////////////////////////////////////////////

    //Returns the name

    /////////////////////////////////////////////////////////////////

    public function get_name()
    {

        return 'epress-countdown';

    }

    /////////////////////////////////////////////////////////////////

    //Returns Title to be Rendered on Frontend

    /////////////////////////////////////////////////////////////////

    public function get_title()
    {

        return esc_html__('Epress CountDown', 'elementpress');

    }

    /////////////////////////////////////////////////////////////////

    //Returns Icon

    /////////////////////////////////////////////////////////////////

    public function get_icon()
    {

        return 'eicon-counter';

    }

    /////////////////////////////////////////////////////////////////

    //Returns Category of Widget In which it will be added

    /////////////////////////////////////////////////////////////////

    public function get_categories()
    {

        return ['additional-addons'];

    }

    /////////////////////////////////////////////////////////////////

    // elementor default function to register your controls

    /////////////////////////////////////////////////////////////////

    protected function register_controls()
    {

        /////////////////////////////////////////////////////////////////

        //  Content Section Dual Heading Start

        /////////////////////////////////////////////////////////////////

        $this->start_controls_section(

        /////////////////////////////////////////////////////////////////

        //Date And Time Control Added Here

        /////////////////////////////////////////////////////////////////

            'section_content',

            [

                'label' => __('Epress CountDown', 'elementpress'),

                'tab' => Controls_Manager::TAB_CONTENT,

            ]

        );


        $this->add_control(

            'epress_due_date',

            [

                'label' => __('Start Date & Time', 'elementpress'),

                'type' => Controls_Manager::DATE_TIME,

            ]

        );

        $this->add_control(

            'epress_outer_bg_color',

            [

                'label' => __('Background Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_4,

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'background-color: {{VALUE}}',

                ],

            ]

        );

        $this->add_group_control(

            Group_Control_Border::get_type(),

            [

                'name' => 'epress_outer_border',

                'label' => __('Outer Border', 'elementpress'),

                'selector' => '{{WRAPPER}} .bg-outer',

            ]

        );

        $this->add_control(

            'epress_outer_border_radius',

            [

                'label' => __('Border Radius', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_control(

            'epress_outer_bg_margin',

            [

                'label' => __('Margin', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_control(

            'epress_outer_bg_padding',

            [

                'label' => __('Padding', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_control(

            'epress_control_outer_bg_height_width',

            [

                'label' => __('Show Height & Width', 'elementpress'),

                'type' => \Elementor\Controls_Manager::SWITCHER,

                'label_on' => __('Show', 'elementpress'),

                'label_off' => __('Hide', 'elementpress'),

                'return_value' => 'yes',

                'default' => 'empty',

            ]

        );

        $this->add_responsive_control(

            'epress_outer_bg_width',

            [

                'label' => __('Background Width', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop', 'tablet', 'mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'width: {{SIZE}}{{UNIT}};',

                ],

                'condition' => ['epress_control_outer_bg_height_width' => 'yes'],

            ]

        );

        $this->add_responsive_control(

            'epress_outer_bg_height',

            [

                'label' => __('Background Height', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop', 'tablet', 'mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-outer' => 'height: {{SIZE}}{{UNIT}};',

                ],

                'condition' => ['epress_control_outer_bg_height_width' => 'yes'],

            ]

        );


        $this->end_controls_section();

        $this->start_controls_section(

        /////////////////////////////////////////////////////////////////

        //Text Styling Controls Added Here

        /////////////////////////////////////////////////////////////////

            'section1_content',

            [

                'label' => __('CountDown Text Style', 'elementpress'),

                'tab' => Controls_Manager::TAB_CONTENT,

            ]

        );

        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'text_typography',

                'label' => __('Text Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '{{WRAPPER}} .smalltext',

            ]

        );

        $this->add_control(

            'epress_outer_title_color',

            [

                'label' => __('Text Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_4,

                ],

                'default' => 'transparent',

                'selectors' => [

                    '{{WRAPPER}} .smalltext' => 'color: {{VALUE}}',

                ],

            ]

        );

        $this->add_control(

            'epress_outer_bg_margin_2',

            [

                'label' => __('Margin', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .smalltext' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_control(

            'epress_outer_bg_padding_2',

            [

                'label' => __('Padding', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .smalltext' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );


        $this->end_controls_section();

/////////////////////////////////////////////////////////////////

        //Text Styling Controls Ends Here

/////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////

        //CountDown Inner Styling Starts Here

/////////////////////////////////////////////////////////////////


        $this->start_controls_section(

            'section2_content',

            [

                'label' => __('CountDown Inner Style', 'elementpress'),

                'tab' => Controls_Manager::TAB_CONTENT,

            ]

        );

        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'epress_counter_typography',

                'label' => __('Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '{{WRAPPER}} .bg-inner',

            ]

        );

        $this->add_control(

            'epress_inner_counter_color',

            [

                'label' => __('Counter Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_3,

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'color: {{VALUE}}',

                ],

            ]

        );

        $this->add_control(

            'epress_inner_bg_color',

            [

                'label' => __('Counter Background Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_3,

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'background-color: {{VALUE}}',

                ],

            ]

        );

        $this->add_group_control(

            Group_Control_Border::get_type(),

            [

                'name' => 'epress_inner_border',

                'label' => __('Outer Border', 'elementpress'),

                'selector' => '{{WRAPPER}} .bg-inner',

            ]

        );

        $this->add_control(

            'epress_inner_border_radius',

            [

                'label' => __('Border Radius', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );


        $this->add_control(

            'epress_inner_bg_margin',

            [

                'label' => __('Margin', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_control(

            'epress_inner_bg_padding',

            [

                'label' => __('Padding', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', '%', 'em'],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );


        $this->add_control(

            'epress_control_height_width',

            [

                'label' => __('Show Height & Width', 'elementpress'),

                'type' => \Elementor\Controls_Manager::SWITCHER,

                'label_on' => __('Show', 'elementpress'),

                'label_off' => __('Hide', 'elementpress'),

                'return_value' => 'yes',

                'default' => 'empty',

            ]

        );

        $this->add_responsive_control(

            'epress_inner_bg_width',

            [

                'label' => __('Background Width', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop', 'tablet', 'mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'width: {{SIZE}}{{UNIT}};',

                ],

                'condition' => ['epress_control_height_width' => 'yes'],

            ]

        );

        $this->add_responsive_control(

            'epress_inner_bg_height',

            [

                'label' => __('Background Height', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop', 'tablet', 'mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .bg-inner' => 'height: {{SIZE}}{{UNIT}};',

                ],

                'condition' => ['epress_control_height_width' => 'yes'],

            ]

        );


        $this->end_controls_section();


        /////////////////////////////////////////////////////////////////

        //CountDown Inner Styling ends Here

/////////////////////////////////////////////////////////////////     

    }

    /**
     * Render the Dual Heading And Dual Button widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    /////////////////////////////////////////////////////////////////

    ////function to show how front all the controls on FrontEnd.

    //front end live preview.

/////////////////////////////////////////////////////////////////


    protected function render()
    {

        $settings = $this->get_settings_for_display();

        $temp = explode(' ', $settings['epress_due_date']);

        $data = explode('-', $temp[0]);

        $time = explode(':', $temp[1]);

        ?>

        <script>

            var deadline = new Date(Date.parse(new Date(<?=$data[0];?>,<?=$data[1] - 1;?>,<?=$data[2];?>,<?=$time[0];?>,<?=$time[1];?>)));

            console.log(deadline);


        </script>

        <div id="clockdiv">

            <div class="bg-outer">

                <span class="days bg-inner">365</span>

                <div class="smalltext">روز</div>

            </div>

            <div class="bg-outer">

                <span class="hours bg-inner">23</span>

                <div class="smalltext">ساعت</div>

            </div>

            <div class="bg-outer">

                <span class="minutes bg-inner">59</span>

                <div class="smalltext">دقیقه</div>

            </div>

            <div class="bg-outer">

                <span class="seconds bg-inner">59</span>

                <div class="smalltext">ثانیه</div>

            </div>

        </div>

        <?php

    }

}



