<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

Class Block_29_Option extends BlockOptionAbstract
{
    protected $default_number_post = 6;
    protected $show_excerpt = false;
    protected $show_ads = true;
    protected $default_ajax_post = 4;

    public function compatible_column()
    {
        return array( 2, 3, 4, 5, 6, 7, 8 , 9, 10, 11, 12 );
    }

    public function get_module_name()
    {
        return esc_html__('epress - Module 29', 'elementpress');
    }

    public function set_style_option()
    {
        $this->options[] = array(
            'type'          => 'checkbox',
            'heading'       => esc_html__('Show bottom border line for each article', 'elementpress'),
            'param_name'    => 'show_border',
            'group'         => esc_html__('Design', 'elementpress'),
        );

        parent::set_style_option();
    }

    public function set_content_setting_option($show_excerpt = false)
    {
        $this->options[] = array(
            'type'          => 'checkbox',
            'heading'       => esc_html__('Tick to show date', 'elementpress'),
            'param_name'    => 'show_date',
            'group'         => esc_html__('Content Setting', 'elementpress'),
            'value'         => array( esc_html__("Show Date", 'elementpress') => 'yes' ),
        );

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'date_format',
            'heading'       => esc_html__('Content Date Format', 'elementpress'),
            'description'   => esc_html__('Choose which date format you want to use.', 'elementpress'),
            'std'           => 'default',
            'group'         => esc_html__('Content Setting', 'elementpress'),
            'value'         => array(
                esc_html__('Relative Date/Time Format (ago)', 'elementpress')               => 'ago',
                esc_html__('WordPress Default Format', 'elementpress')      => 'default',
                esc_html__('Custom Format', 'elementpress')                 => 'custom',
            )
        );

        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'date_format_custom',
            'heading'       => esc_html__('Custom Date Format', 'elementpress'),
            'description'   => wp_kses(sprintf(__('Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'elementpress'), 'https://codex.wordpress.org/Formatting_Date_and_Time'), wp_kses_allowed_html()),
            'group'         => esc_html__('Content Setting', 'elementpress'),
            'std'           => 'Y/m/d',
            'dependency'    => array('element' => 'date_format', 'value' => array('custom'))
        );

        if($show_excerpt)
        {
            $this->options[] = array(
                'type'          => 'slider',
                'param_name'    => 'excerpt_length',
                'heading'       => esc_html__('Excerpt Length', 'elementpress'),
                'description'   => esc_html__('Set word length of excerpt on post block.', 'elementpress'),
                'group'         => esc_html__('Content Setting', 'elementpress'),
                'min'           => 0,
                'max'           => 200,
                'step'          => 1,
                'std'           => 20,
            );
        }
    }

	public function set_typography_option( $instance ) {
        
        $instance->add_control(
			'tittle_color',
			[
				'label' => esc_html__( 'Title Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Title Color', 'elementpress' ),
				'description' => esc_html__( 'Set Title Color for post title.', 'elementpress' ),
                
				'selectors' => [
					'{{WRAPPER}} .jeg_post_title  a' => 'color: {{VALUE}}',
					
				],
                
				
			]
		);

        $instance->add_control(
			'meta-color',
			[
				'label' => esc_html__( 'Meta Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Meta  Color', 'elementpress' ),
				'description' => esc_html__( 'This option will change your meta color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_meta' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_meta .fa' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_pl_md_card .jeg_post_category a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a.current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_meta_date a' => 'color: {{VALUE}}',

				],
                
				
			]
		);
        $instance->add_control(
			'acent-and-hover-color',
			[
				'label' => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'description' => esc_html__( 'This option will change your accent color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_author a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_title a:hover' => 'color: {{VALUE}}',	
					
				],
                
				
			]
		);


		$instance->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Expcerpt Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'description' => esc_html__( 'This option will change your excerpt color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_excerpt' => 'color: {{VALUE}}',
					
					
					
				],
                
				
			]
		);
		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);
	}
}
