<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

Class Block_38_Option extends BlockOptionAbstract
{
	protected $default_number_post = 6;
	protected $show_excerpt = true;
	protected $default_ajax_post = 4;

	public function get_module_name()
	{
		return esc_html__('ElementPress - Module 38', 'elementpress');
	}

	public function additional_style()
	{
		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'title_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Title Color', 'elementpress'),
			'description'   => esc_html__('This option will change your Title color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'accent_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Accent Color & Link Hover', 'elementpress'),
			'description'   => esc_html__('This option will change your accent color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'alt_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Meta Color', 'elementpress'),
			'description'   => esc_html__('This option will change your meta color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'block_background',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Block Background', 'elementpress'),
			'description'   => esc_html__('This option will change your Block Background', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'checkbox',
			'param_name'    => 'box_shadow',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Box Shadow', 'elementpress'),
			'std'           => false
		);

	}
}
