<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Hero;

use EPRESS\Module\ModuleOptionAbstract;

abstract Class HeroOptionAbstract extends ModuleOptionAbstract
{
    protected $number_post = 0;
    protected $margin = 0;
    protected $show_style = true;

    public function get_number_post()
    {
        return $this->number_post;
    }

	public function get_category()
	{
		return esc_html__('EPRESS - Hero', 'elementpress');
	}

    public function compatible_column()
    {
        return array( 12 );
    }

    public function show_color_scheme()
    {
        return false;
    }

    public function set_options()
    {
        $this->set_hero_option();
        $this->set_content_filter_option($this->number_post, true);
        if($this->show_style) {
            $this->set_hero_design_option();
	        $this->set_hero_overlay_option();
            $this->set_hero_slider_option();
        }
        $this->set_style_option();
    }

    public function set_hero_overlay_option()
    {
        for($i = 1; $i <= $this->number_post; $i++)
        {
            $this->options[] = array(
                'type'          => 'checkbox',
                'param_name'    => 'hero_item_' . $i . '_enable',
                'heading'       => sprintf(esc_html__('Override overlay for item %s', 'elementpress'), $i),
                'group'         => esc_html__('Hero Style', 'elementpress'),
                'description'   => esc_html__('Override overlay style for this item', 'elementpress'),
            );

            $this->options[] = array(
                'type'          => 'slider',
                'param_name'    => 'hero_item_' . $i . '_degree',
                'heading'       => sprintf(esc_html__('Hero Item %s : Overlay Gradient Degree', 'elementpress'), $i),
                'group'         => esc_html__('Hero Style', 'elementpress'),
                'min'           => 0,
                'max'           => 360,
                'step'          => 1,
                'std'           => 0,
                'dependency'    => array('element' => 'hero_item_' . $i . '_enable', 'value' => 'true')
            );

            $this->options[] = array(
                'type'          => 'colorpicker',
                'std'           => 'rgba(255,255,255,0.5)',
                'param_name'    => 'hero_item_' . $i . '_start_color',
                'group'         => esc_html__('Hero Style', 'elementpress'),
                'heading'       => sprintf(esc_html__('Hero Item %s : Gradient Start Color', 'elementpress'), $i),
                'dependency'    => array('element' => 'hero_item_' . $i . '_enable', 'value' => 'true')
            );

            $this->options[] = array(
                'type'          => 'colorpicker',
                'std'           => 'rgba(0,0,0,0.5)',
                'param_name'    => 'hero_item_' . $i . '_end_color',
                'group'         => esc_html__('Hero Style', 'elementpress'),
                'heading'       => sprintf(esc_html__('Hero Item %s : Gradient End Color', 'elementpress'), $i),
                'dependency'    => array('element' => 'hero_item_' . $i . '_enable', 'value' => 'true')
            );
        }
    }

    public function set_hero_design_option()
    {
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_desktop',
            'heading'       => esc_html__('Hero Height on Dekstop', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_1024',
            'heading'       => esc_html__('Hero Height on 1024px Width Screen', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_768',
            'heading'       => esc_html__('Hero Height on 768px Width Screen', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_667',
            'heading'       => esc_html__('Hero Height on 667px Width Screen', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_568',
            'heading'       => esc_html__('Hero Height on 568px Width Screen', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'hero_height_480',
            'heading'       => esc_html__('Hero Height on 480px Width Screen', 'elementpress'),
            'description'   => esc_html__('Height on pixel / px, leave it empty to use the default number.', 'elementpress'),
            'group'         => esc_html__('Hero Design', 'elementpress'),
        );
    }

    public function set_hero_option()
    {
        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'hero_margin',
            'heading'       => esc_html__('Hero Margin', 'elementpress'),
            'description'   => esc_html__('Margin of each hero element.', 'elementpress'),
            'group'         => esc_html__('Hero Setting', 'elementpress'),
            'min'           => 0,
            'max'           => 30,
            'step'          => 1,
            'std'           => 0,
        );
        $this->options[] = array(
            'type'          => 'radioimage',
            'param_name'    => 'hero_style',
            'std'           => 'jeg_hero_style_1',
            'value'         => array(
                EPRESS_URL . '/assets/img/admin/hero-1.png'  => 'jeg_hero_style_1',
                EPRESS_URL . '/assets/img/admin/hero-2.png'  => 'jeg_hero_style_2',
                EPRESS_URL . '/assets/img/admin/hero-3.png'  => 'jeg_hero_style_3',
                EPRESS_URL . '/assets/img/admin/hero-4.png'  => 'jeg_hero_style_4',
                EPRESS_URL . '/assets/img/admin/hero-5.png'  => 'jeg_hero_style_5',
                EPRESS_URL . '/assets/img/admin/hero-6.png'  => 'jeg_hero_style_6',
                EPRESS_URL . '/assets/img/admin/hero-7.png'  => 'jeg_hero_style_7',
            ),
            'heading'       => esc_html__('Hero Style', 'elementpress'),
            'description'   => esc_html__('Choose which hero style that fit your content design.', 'elementpress'),
            'group'         => esc_html__('Hero Setting', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'date_format',
            'heading'       => esc_html__('Choose Date Format', 'elementpress'),
            'description'   => esc_html__('Choose which date format you want to use.', 'elementpress'),
            'std'           => 'default',
            'group'         => esc_html__('Hero Setting', 'elementpress'),
            'value'         => array(
                esc_html__('Relative Date/Time Format (ago)', 'elementpress')               => 'ago',
                esc_html__('WordPress Default Format', 'elementpress')      => 'default',
                esc_html__('Custom Format', 'elementpress')                 => 'custom',
            )
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'date_format_custom',
            'heading'       => esc_html__('Custom Date Format', 'elementpress'),
            'description'   => wp_kses(sprintf(__('Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'elementpress'), 'https://codex.wordpress.org/Formatting_Date_and_Time'), wp_kses_allowed_html()),
            'std'           => 'Y/m/d',
            'group'         => esc_html__('Hero Setting', 'elementpress'),
            'dependency'    => array('element' => 'date_format', 'value' => array('custom'))
        );
    }

	public function set_hero_slider_option()
	{
		$this->options[] = array(
			'type'          => 'checkbox',
			'param_name'    => 'hero_slider_enable',
			'heading'       => esc_html__('Hero Slider', 'elementpress'),
			'description'   => esc_html__('Enable hero slider.', 'elementpress'),
			'group'         => esc_html__('Hero Slider', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'checkbox',
			'param_name'    => 'hero_slider_auto_play',
			'heading'       => esc_html__('Slider Autoplay', 'elementpress'),
			'description'   => esc_html__('Enable autoplay hero slider.', 'elementpress'),
			'group'         => esc_html__('Hero Slider', 'elementpress'),
			'dependency'    => array('element' => 'hero_slider_enable', 'value' => 'true')
		);

		$this->options[] = array(
			'type'          => 'slider',
			'param_name'    => 'hero_slider_delay',
			'heading'       => esc_html__('Autoplay Delay', 'elementpress'),
			'description'   => esc_html__('Set your autoplay delay (in millisecond).', 'elementpress'),
			'min'           => 1000,
			'max'           => 10000,
			'step'          => 500,
			'std'           => 3000,
			'group'         => esc_html__('Hero Slider', 'elementpress'),
			'dependency'    => array('element' => 'hero_slider_auto_play', 'value' => 'true')
		);

		$this->options[] = array(
			'type'          => 'slider',
			'param_name'    => 'hero_slider_item',
			'heading'       => esc_html__('Slider Item', 'elementpress'),
			'description'   => esc_html__('Set number of items of hero slider.', 'elementpress'),
			'group'         => esc_html__('Hero Slider', 'elementpress'),
			'min'           => 1,
			'max'           => 10,
			'step'          => 1,
			'std'           => 3,
			'dependency'    => array('element' => 'hero_slider_enable', 'value' => 'true')
		);
	}

	public function set_typography_option( $instance ) {

        $instance->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .jeg_post_title > a' => 'color: {{VALUE}}',
				],
			]
		);




		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
        );
        $instance->add_control(
			'epress_meta_author_color',
			[
				'label' => __( 'Meta Author Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_author > span, {{WRAPPER}} .jeg_meta_author > a, {{WRAPPER}} .jeg_meta_date::before' => 'color: {{VALUE}}',
				],
			]
        );        
        $instance->add_control(
			'epress_meta_clock_color',
			[
				'label' => __( 'Meta Clock Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .fa.fa-clock-o' => 'color: {{VALUE}}',
				],
			]
        );        
        $instance->add_control(
			'epress_meta_date_color',
			[
				'label' => __( 'Meta Date Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_date a' => 'color: {{VALUE}}',
				],
			]
		);
        $instance->add_control(
			'epress_category_switcher',
			[
				'label' => __( 'Category Style', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
        );
        $instance->add_control(
			'epress_category_hero_color',
			[
				'label' => __( 'Category Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hero_hover_color',
			[
				'label' => __( 'Category Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        
        $instance->add_control(
			'epress_category_hero_bg_color',
			[
				'label' => __( 'Category Background Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_control(
			'epress_category_hero_bg_hover_color',
			[
				'label' => __( 'Category Background Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'category_typography',
			    'label'       => esc_html__( 'Category Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post Category', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],    
            ]
        );
        
		$instance->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'epress_cat_border',
				'label' => __( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_control(
			'epress_category_hero_border_hover_color',
			[
				'label' => __( 'Category Border Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'border-color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hero_border_radius',
			[
				'label' => __( 'Category Border Radius', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);

        $instance->add_control(
			'epress_hero_category_margin',
			[
				'label' => __( 'Category Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        $instance->add_control(
			'epress_hero_category_padding',
			[
				'label' => __( 'Category Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_control(
            'epress_display_hero_meta_admin',
            [
                'label' => __( 'Hide Meta Admin', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'On', 'elementpress' ),
                'label_off' => __( 'Off', 'elementpress' ),
                'return_value' => 'yes',
                // 'default' => 'empty',
                'selectors' => [
					'{{WRAPPER}} .jeg_meta_author, {{WRAPPER}} .jeg_meta_date::before' => 'display: none;',
                ],
            ]
        );
        $instance->add_control(
            'epress_display_hero_meta_date',
            [
                'label' => __( 'Hide Meta Date', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'On', 'elementpress' ),
                'label_off' => __( 'Off', 'elementpress' ),
                'return_value' => 'yes',
                // 'default' => 'empty',
                    'selectors' => [
                        '{{WRAPPER}} .jeg_meta_date' => 'display: none;',
                    ],
                
            ]
        );
	}
}
