<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Slider;

use EPRESS\Module\ModuleOptionAbstract;

abstract Class SliderOptionAbstract extends ModuleOptionAbstract
{
    protected $default_number = 4;

    public function compatible_column()
    {
        return array( 8, 12 );
    }

	public function get_category()
	{
		return esc_html__('epress - Slider', 'elementpress');
	}

	public function show_color_scheme()
    {
        return false;
    }

    public function set_options()
    {
        $this->set_slider_option();
        $this->set_content_filter_option($this->default_number);
        $this->set_style_option();
    }

    public function set_slider_option()
    {
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'enable_autoplay',
            'heading'       => esc_html__('Enable Autoplay', 'elementpress'),
            'description'   => esc_html__('Check this option to enable auto play.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'autoplay_delay',
            'heading'       => esc_html__('Autoplay Delay', 'elementpress'),
            'description'   => esc_html__('Set your autoplay delay (in millisecond).', 'elementpress'),
            'min'           => 1000,
            'max'           => 10000,
            'step'          => 500,
            'std'           => 3000,
            'dependency'    => array('element' => 'enable_autoplay', 'value' => 'true')
        );
        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'date_format',
            'heading'       => esc_html__('Choose Date Format', 'elementpress'),
            'description'   => esc_html__('Choose which date format you want to use.', 'elementpress'),
            'std'           => 'default',
            'value'         => array(
                esc_html__('Relative Date/Time Format (ago)', 'elementpress')  => 'ago',
                esc_html__('WordPress Default Format', 'elementpress')         => 'default',
                esc_html__('Custom Format', 'elementpress')                    => 'custom',
            )
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'date_format_custom',
            'heading'       => esc_html__('Custom Date Format', 'elementpress'),
            'description'   => wp_kses(sprintf(__('Please write custom date format for your module, for more detail about how to write date format, you can refer to this <a href="%s" target="_blank">link</a>.', 'elementpress'), 'https://codex.wordpress.org/Formatting_Date_and_Time'), wp_kses_allowed_html()),
            'std'           => 'Y/m/d',
            'dependency'    => array('element' => 'date_format', 'value' => array('custom'))
        );
    }

	public function set_typography_option( $instance ) {
        $instance->add_control(
			'tittle_color',
			[
				'label' => esc_html__( 'Title Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Title Color', 'elementpress' ),
				'description' => esc_html__( 'Set Title Color for post title.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_slide_caption .jeg_post_title a' => 'color: {{VALUE}}',
					
				],
                
				
			]
		);

        $instance->add_control(
			'meta-color',
			[
				'label' => esc_html__( 'Meta Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Meta  Color', 'elementpress' ),
				'description' => esc_html__( 'This option will change your meta color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_post_meta' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_post_meta .fa' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_pl_md_card .jeg_post_category a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_postblock .jeg_subcat_list > li > a.current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_meta_date a' => 'color: {{VALUE}}',

				],
                
				
			]
		);
        $instance->add_control(
			'acent-and-hover-color',
			[
				'label' => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,	
				'label'       => esc_html__( 'Accent Color & Link Hover
				', 'elementpress' ),
				'description' => esc_html__( 'This option will change your accent color.', 'elementpress' ),
				'selectors' => [
					'{{WRAPPER}} .jeg_meta_author a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .jeg_slide_caption .jeg_post_meta a' => 'color: {{VALUE}}',
                    // '{{WRAPPER}} .jeg_slide_caption a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .jeg_slide_caption .jeg_post_title a:hover' => 'color: {{VALUE}}',	
					
				],
                
				
			]
		);

        $instance->add_control(
			'epress_category_switcher',
			[
				'label' => __( 'Category Style', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
        );
        $instance->add_control(
			'epress_category_hero_color',
			[
				'label' => __( 'Category Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hero_hover_color',
			[
				'label' => __( 'Category Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        
        $instance->add_control(
			'epress_category_hero_bg_color',
			[
				'label' => __( 'Category Background Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_control(
			'epress_category_hero_bg_hover_color',
			[
				'label' => __( 'Category Background Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'category_typography',
			    'label'       => esc_html__( 'Category Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post Category', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],    
            ]
        );
        
		$instance->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'epress_cat_border',
				'label' => __( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_control(
			'epress_category_hero_border_hover_color',
			[
				'label' => __( 'Category Border Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'border-color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hero_border_radius',
			[
				'label' => __( 'Category Border Radius', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);

        $instance->add_control(
			'epress_hero_category_margin',
			[
				'label' => __( 'Category Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        $instance->add_control(
			'epress_hero_category_padding',
			[
				'label' => __( 'Category Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );

		

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);



	}
}
