<?php


$status = ElementPress\Libs\Framework\Classes\License::instance()->status();








?>


<div class="epress-wid-con">


    <div class="epress_container" style="max-width: 768px;">


        <form action="" method="POST" class="epress-admin-form" id="epress-admin-license-form">


            <div class="epress_tab_wraper">


                <div class="epress-admin-section-header">


                    <h2 class="epress-admin-section-heaer-title"><i class="icon icon-key2"></i><?php echo esc_html__('License Settings', 'elementpress'); ?></h2>


                </div>


                <div class="epress-admin-card attr-tab-content epress-admin-card-shadow">





                    <div class="attr-card-body">


                        <?php if($status != 'valid'): ?>


                        <p><?php esc_html_e('Enter your license key here, to activate Elementor Pro, and get feature updates, premium support and unlimited access to the template library.', 'elementpress'); ?></p>





                        <ol>


                            <li><?php printf( esc_html__( 'Log in to your %sCodeCanyon account%s to get your license key.', 'elementpress' ), '<a href="https://codecanyon.net/" target="_blank">', '</a>' ); ?></li>


                            <li><?php printf( esc_html__( 'If you don\'t yet have a license key, get %sElementorOpt%s now.', 'elementpress' ),


                                        '<a href="https://codecanyon.net/item/elements-kit-all-in-one-addons-for-elementor-page-builder/23858707" target="_blank">', '</a>' );


                                ?></li>


                            <li><?php esc_html_e('Copy the ElementorOpt license key from your CodeCanyon account and paste it below.', 'elementpress'); ?></li>


                        </ol>





                        <label for="epress-admin-option-text-elementpress-license-key"><?php esc_html_e('Your License Key'); ?></label>


                        <div class="form-group attr-input-group epress-admin-input-text epress-admin-input-text--elementpress-license-key">


                            <input


                                type="text"


                                class="attr-form-control"


                                id="epress-admin-option-text-elementpress-license-key"


                                aria-describedby="epress-admin-option-text-help-elementpress-license-key"


                                placeholder="<?php echo esc_attr('Please insert your license key here', 'elementpress'); ?>"


                                name="elementkit_pro_license_key"


                                value=""


                            >


                            <span class="attr-input-group-btn">


                                <input type="hidden" name="type" value="activate" />


                                <button class="attr-btn btn-license-activate attr-btn-primary epress-admin-license-form-submit" type="submit" ><div class="epress-spinner"></div><?php esc_html_e('Activate', 'elementpress'); ?></button>


                            </span>


                        </div>





                        <div class="elementpress-license-form-result">


                            <p class="attr-alert attr-alert-info">


                                <?php printf( esc_html__( 'Your license key should look something like this: %s', 'elementpress' ), '<code>18ef758a-7a48-4877-b0ac-5622aab1da3</code>' ); ?>


                            </p>


                        </div>


                        <?php else: ?>


                            <div class="elementpress-license-form-result">


                                <p class="attr-alert attr-alert-success">


                                    <?php printf( esc_html__('Congratulations! You\'r product is activated for "%s"', 'elementpress'), parse_url(home_url(), PHP_URL_HOST)); ?>


                                </p>


                            </div>


                            <div class="attr-revoke-btn-container">


                                <input type="hidden" name="type" value="revoke" />


                                <button class="attr-btn btn-license-revoke attr-btn-primary epress-admin-license-form-submit" type="submit" ><div class="epress-spinner"></div><?php esc_html_e('Revoke license for this domain', 'elementpress'); ?></button>


                            </div>





                        <?php endif; ?>


                    </div>


                </div>


            </div>


        </form>


    </div>


</div>