<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;
class Epress_posttitle extends Widget_Base {
	public $base;
    public function get_name() {
		return 'Epress-PostTitle';
    }
    public function get_title() {
		return esc_html__( 'Epress Post Title', 'elementpress' );
    }
    public function get_icon() {
		return 'eicon-post-title';
    }
    public function get_categories() {
        return [ 'additional-addons' ];
    }
    protected function register_controls() {
		//single post section after draging single post widget in front-end
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Single Post Title', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//controls inside single post title section
		//select different headings control
        $this->add_control(
			'html_tags',
			[
				'label' => __( 'Html Tags', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => [
					'h1'  => __('H1', 'elementpress' ),
					'h2' => __( 'H2', 'elementpress' ),
					'h3' => __( 'H3', 'elementpress' ),
					'h4' => __( 'H4', 'elementpress' ),
                    'h5' => __( 'H5', 'elementpress' ),
                    'h6' => __( 'H6', 'elementpress' ),
				],
			]
		);
		//choose control to align text
        $this->add_control(
			'title_align',
			[
				'label' => __( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementpress' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementpress' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .post_title' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section(); //end first section
		//style section under single post title section
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//typography control inside style section
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .post_title a',
			]
        );
         //color picker control inside style section
         $this->add_control(
        	'title_color',
        	[
        		'label' => __( 'Title Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
 			 'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .post_title a' => 'color: {{VALUE}}',
        		],
        	]
        );
        $this->end_controls_section();
	}
	//how display will look on front end
    protected function render() {
		//getting all the settings (control title)of every controls and section.
        $settings = $this->get_settings_for_display();
		$queried_object = get_queried_object();

		if ( $queried_object ) {
			$post_id = $queried_object->ID;
		//	echo $post_id;
		}
		?>
		<div class="post_title">
		<<?php echo $settings['html_tags']; ?>>
		<a href="<?php the_permalink($post_id); ?>">
			<?php echo get_the_title($post_id);?></a>
		</<?php echo $settings['html_tags']; ?>>
		</div>
		<?php
		
}
    protected function content_template() { }
}