<?php

namespace Elementor;
use \Elementor\Controls_Manager;


if ( ! defined( 'ABSPATH' ) ) exit;
class ElementPress_widget_Price extends Widget_Base {
	public $base;

	
    public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);


        wp_register_style( 'price-css',  \ElementPress::widgets_url() . '/price/assets/price.css', false, \ElementPress::version );

     }


	  public function get_style_depends() {
		 
		 return [ 'price-css' ];
	  }

    public function get_name() {
		//get name from price-handler file
        return 'elementpress-price';
    }
    public function get_title() {
		//get title from price-handler file
		return esc_html__( 'Epress Price', 'elementpress' );
    }
    public function get_icon() {
		//get icon from price-handler file
        return 'eicon-product-price';
    }
    public function get_categories() {
		//get category where widget will be added in elementor front end
		return [ 'additional-addons' ];
	}
	// elementor default function to register your controls
	protected function register_controls() {
//  Content Section Dual Heading Start
$this->start_controls_section(
	//section which is shown after you drage your widget in the fornt-end area
	'section_content',
	[
		'label' => __('Dual Heading', 'additional-addons'),//......
	]
);
// adding switcher to hide or show From.
$this->add_control(
	'show_from',
	[
		'label' => __( 'Show From', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'additional-addons' ),
		'label_off' => __( 'Hide', 'additional-addons' ),
		'return_value' => 'yes',
		'default' => 'yes',
	]
);
// adding input text field named From.
$this->add_control(
	'from',
	[
		'label' => __( 'From ', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'default' => __( 'From', 'additional-addons' ),
		'placeholder' => __( 'Type yourFrom here', 'additional-addons' ),
		'condition' => ['show_from' => 'yes'],
	]
);
// adding switcher to hide or show currency sign.
$this->add_control(
	'show_currency_sign',
	[
		'label' => __( 'Show Currency Sign', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'additional-addons' ),
		'label_off' => __( 'Hide', 'additional-addons' ),
		'return_value' => 'yes',
		'default' => 'yes',
	]
);
// adding input text named Currency Price.
$this->add_control(
	'currency_sign',
	[
		'label' => __( 'Currency Sign', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'default' => __( '$', 'additional-addons' ),
		'placeholder' => __( 'Add your Currency Sign here', 'additional-addons' ),
		'condition' => ['show_price' => 'yes'],
	]
);
// adding switcher to hide or show price.
$this->add_control(
	'show_price',
	[
		'label' => __( 'Show Price', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'additional-addons' ),
		'label_off' => __( 'Hide', 'additional-addons' ),
		'return_value' => 'yes',
		'default' => 'yes',
	]
);
// adding input text named Price.
$this->add_control(
	'price',
	[
		'label' => __( 'Price ', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'default' => __( '100', 'additional-addons' ),
		'placeholder' => __( 'Type your Price here', 'additional-addons' ),
		'condition' => ['show_price' => 'yes'],
	]
);
//Price in Deimel Values
$this->add_control(
            'show_price_in_decimel_value',
            [
                'label' => __( 'Show Price in Decimel Value', 'additional-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'additional-addons' ),
                'label_off' => __( 'Hide', 'additional-addons' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
// adding input text for price in decimel value.
        $this->add_control(
            'decimel_price',
            [
                'label' => __( 'Price in Decimel', 'additional-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '.00', 'additional-addons' ),
                'placeholder' => __( 'Add your Value here', 'additional-addons' ),
                'condition' => ['show_price_in_decimel_value' => 'yes'],
            ]
        );
//  switcher to hide or show Duration.
$this->add_control(
	'show_duration',
	[
		'label' => __( 'Show Duration', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'additional-addons' ),
		'label_off' => __( 'Hide', 'additional-addons' ),
		'return_value' => 'yes',
		'default' => 'yes',
	]
);
//adding input text feild named duration.
$this->add_control(
	'duration',
	[
		'label' => __( 'Duration ', 'additional-addons' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'default' => __( 'month', 'additional-addons' ),
		'placeholder' => __( 'Type your Duration here', 'additional-addons' ),
		'condition' => ['show_duration' => 'yes']
	]
);

// select Box with / option

$this->add_control(
	'epress_show_seperator',
	[
		'label' => __( 'Price Seperation Tag', 'elementpress' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'elementpress' ),
		'label_off' => __( 'Hide', 'elementpress' ),
		'return_value' => 'yes',
		'default' => 'empty',
	]
);

$this->add_control(
	'content_seperation',
	[
		'label' => __( 'Content HTML Tag', 'additional-addons' ),
		'type' => Controls_Manager::SELECT,
		'options' => [
			'/'=>'/',
		],
		'condition' => ['epress_show_seperator' => 'yes'],
		'default' => '/',
	]
);

// Content Alignment...
$this->add_control(
	'cont_align',
	[
	'label' => __( 'Content Alignment', 'additional-addons' ),
	'type' => \Elementor\Controls_Manager::CHOOSE,
	'options' => [
		'left' => [
		'title' => __( 'Left', 'additional-addons' ),
		'icon' => 'eicon-text-align-left',
		],
		'center' => [
			'title' => __( 'Center', 'additional-addons' ),
			'icon' => 'eicon-text-align-center',
		],
		'right' => [
			'title' => __( 'Right', 'additional-addons' ),
			'icon' => 'eicon-text-align-right',
		],
	],
	'default' => 'center',
	'toggle' => true,
	]
);
$this->add_control(
	'show_inline',
	[
		'label' => __( 'Show Inline', 'elementpress' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'elementpress' ),
		'label_off' => __( 'Hide', 'elementpress' ),
		'return_value' => 'yes',
		'default' => 'yes',
	]
);
//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////Absolute Position For "FROM"/////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

$this->add_control(
	'epress_absolute_position_from',
	[
		'label' => __( '&quot;From&quot; Position Absolute', 'elementpress' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'elementpress' ),
		'label_off' => __( 'Hide', 'elementpress' ),
		'return_value' => 'yes',
		'default' => 'empty',
		'condition' => ['show_from' => 'yes']
	]
);

$this->add_control(
	'position_for_btn',
	[
		'label' => __( 'Button Position', 'elementpress' ),
		'label_block' => true,
		'type' => Controls_Manager::SELECT,
		'multiple' => true,
		'default' =>__( 'absolute' , 'elementpress' ),
		'options' => [					
			'relative' => __( 'Relative', 'elementpress' ),
			'absolute' => __( 'Absolute', 'elementpress' ),
			'fixed' => __( 'Fixed', 'elementpress' ),

		],
		'condition' => ['epress_absolute_position_from' => 'yes'],
		//'separator' => 'before',
	]
);

//top slider control
$this->add_control(
	'position_for_btn_top',
	[
		'label' => __( 'TOP', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .from' => 'top: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_from' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_right',
	[
		'label' => __( 'RIGHT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .from' => 'right: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_from' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_left',
	[
		'label' => __( 'LEFT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .from' => 'left: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_from' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_bottom',
	[
		'label' => __( 'BOTTOM', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .from' => 'bottom: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_from' => 'yes'],
	]
);
//////////////////////////////////////////////////////////////////////////////////////
// //////////////////////////Absolute Position For "FROM" End//////////////////////////
//////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////////
// //////////////////////////Absolute Position For "Price"/////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////


$this->add_control(
	'epress_absolute_position_price',
	[
		'label' => __( '&quot;Duration&quot; Position Absolute', 'elementpress' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'elementpress' ),
		'label_off' => __( 'Hide', 'elementpress' ),
		'return_value' => 'yes',
		'default' => 'empty',
		'condition' => ['show_price' => 'yes']
	
	]
);

$this->add_control(
	'position_for_btn_price',
	[
		'label' => __( 'Button Position', 'elementpress' ),
		'label_block' => true,
		'type' => Controls_Manager::SELECT,
		'multiple' => true,
		'default' =>__( 'absolute' , 'elementpress' ),
		'options' => [					
			'relative' => __( 'Relative', 'elementpress' ),
			'absolute' => __( 'Absolute', 'elementpress' ),
			'fixed' => __( 'Fixed', 'elementpress' ),

		],
		'condition' => ['epress_absolute_position_price' => 'yes'],
		//'separator' => 'before',
	]
);

//top slider control
$this->add_control(
	'position_for_btn_top_price',
	[
		'label' => __( 'TOP', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .duration' => 'top: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_price' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_right_price',
	[
		'label' => __( 'RIGHT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .duration' => 'right: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_price' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_left_price',
	[
		'label' => __( 'LEFT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .duration' => 'left: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_price' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_bottom_price',
	[
		'label' => __( 'BOTTOM', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .duration' => 'bottom: {{VALUE}}px;',
		],
		
		'condition' => ['epress_absolute_position_price' => 'yes'],
	]
);


$this->add_control(
	'epress_absolute_position_decimal',
	[
		'label' => __( '&quot;Decimal&quot; Position Absolute', 'elementpress' ),
		'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'Show', 'elementpress' ),
		'label_off' => __( 'Hide', 'elementpress' ),
		'return_value' => 'yes',
		'default' => 'empty',
		'condition' => ['show_price_in_decimel_value' => 'yes']

	]
);

$this->add_control(
	'position_for_btn_decimal',
	[
		'label' => __( 'Button Position', 'elementpress' ),
		'label_block' => true,
		'type' => Controls_Manager::SELECT,
		'multiple' => true,
		'default' =>__( 'absolute' , 'elementpress' ),
		'options' => [
			'relative' => __( 'Relative', 'elementpress' ),
			'absolute' => __( 'Absolute', 'elementpress' ),
			'fixed' => __( 'Fixed', 'elementpress' ),

		],
        'selectors' => [
            '{{WRAPPER}}  .decimel-price' => 'position: {{VALUE}};',
        ],
		'condition' => ['epress_absolute_position_decimal' => 'yes'],
		//'separator' => 'before',
	]
);

//top slider control
$this->add_control(
	'position_for_btn_top_decimal',
	[
		'label' => __( 'TOP', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .decimel-price' => 'top: {{VALUE}}px;',
		],

		'condition' => ['epress_absolute_position_decimal' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_right_decimal',
	[
		'label' => __( 'RIGHT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .decimel-price' => 'right: {{VALUE}}px;',
		],

		'condition' => ['epress_absolute_position_decimal' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_left_decimal',
	[
		'label' => __( 'LEFT', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .decimel-price' => 'left: {{VALUE}}px;',
		],

		'condition' => ['epress_absolute_position_decimal' => 'yes'],
	]
);


$this->add_control(
	'position_for_btn_bottom_decimal',
	[
		'label' => __( 'BOTTOM', 'elementpress' ),
		'type' => Controls_Manager::NUMBER,
		'default' =>'',
		'selectors' => [
			'{{WRAPPER}}  .decimel-price' => 'bottom: {{VALUE}}px;',
		],

		'condition' => ['epress_absolute_position_decimal' => 'yes'],
	]
);



//////////////////////////////////////////////////////////////////////////////////////
// //////////////////////////Absolute Position For "Price" End////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
$this->end_controls_section();
//antoher control section for style
$this->start_controls_section(
	'section_style',
	[
		'label' => __( 'Style', 'additional-addons' ),
		'tab' => Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'content_bg_color',
	[
		'label' => __( 'Content Background Color', 'elementpress' ),
		'type' => Controls_Manager::COLOR,
		//'default' => '#000',
		'selectors' => [
			'{{WRAPPER}} .epress-price-content' => 'background-color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	Group_Control_Border::get_type(),
	[
		'name' => 'border',
		'label' => __( 'Border', 'elementpress' ),
		'selector' => '{{WRAPPER}} .epress-price-content',
	]
);
$this->add_control(
	'content_border_radius',
	[
		'label' => __( 'Content Border Radius', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .epress-price-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);

$this->add_group_control(
	Group_Control_Box_Shadow::get_type(),
	[
		'name' => 'box_shadow',
		'label' => __( 'Box Shadow', 'elementpress' ),
		'selector' => '{{WRAPPER}} .epress-price-content',
	]
);

$this->add_responsive_control(
	'epress_icon_width',
	[
		'label' => __('Icon Width', 'elementpress'),
		'type' => Controls_Manager::SLIDER,
		'size_units' => ['px', '%'],
		'devices' => ['desktop','tablet','mobile'],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 5,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
			],
		],
		'selectors' => [
			'{{WRAPPER}} .epress-price-content' => 'width: {{SIZE}}{{UNIT}};',
		],
	]
);
$this->add_responsive_control(
	'epress_icon_height',
	[
		'label' => __('Icon Height', 'elementpress'),
		'type' => Controls_Manager::SLIDER,
		'size_units' => ['px', '%'],
		'devices' => ['desktop','tablet','mobile'],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 5,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
			],
		],
		'selectors' => [
			'{{WRAPPER}} .epress-price-content' => 'height: {{SIZE}}{{UNIT}};',
		],
	]
);

$this->add_control(
	'epress_content_padding',
	[
		'label' => __( 'Content Padding', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .epress-price-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);


//From Color Change
$this->add_control(
	'from_color',
	[
		'label' => __( 'From Color Text', 'additional-addons' ),
		'type' => Controls_Manager::COLOR,
		'default' => '#000',
		'selectors' => [
			'{{WRAPPER}} .from' => 'color: {{VALUE}}',
		],
	]
);


//Duration Color Change
$this->add_control(
	'duration_color',
	[
		'label' => __( 'Duration Color Text', 'additional-addons' ),
		'type' => Controls_Manager::COLOR,
		'default' => '#000',
		'selectors' => [
			'{{WRAPPER}} .duration' => 'color: {{VALUE}}',
		],
	]
);
//Layout From
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'from_typography',
		'label' => __( 'From Typography', 'additional-addons' ),
		'selector' => '{{WRAPPER}} .from',
	]
);


//Layout Duration
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'duration_typography',
		'label' => __( 'Duration Typography', 'additional-addons' ),
		'selector' => '{{WRAPPER}} .duration',
	]
);

$this->end_controls_section();
	

	$this->start_controls_section(
		'section_style1',
		[
			'label' => __( 'From Style', 'additional-addons' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
	
$this->add_control(
	'epress_from_margin',
	[
		'label' => __( 'Margin', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .from p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			
				
		],
	]
);

	$this->end_controls_section();

	$this->start_controls_section(
		'section_style2',
		[
			'label' => __( 'Price Style', 'additional-addons' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);

        $this->add_control(
            'price_color',
            [
                'label' => __( 'Price Color Text', 'additional-addons' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .price' => 'color: {{VALUE}}',
                ],
            ]
        );
        //Layout Price
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'label' => __( 'Price Typography', 'additional-addons' ),
                'selector' => '{{WRAPPER}} .price',
            ]
        );
$this->add_control(
	'epress_price_margin',
	[
		'label' => __( 'Margin', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .price div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
	$this->end_controls_section();

	$this->start_controls_section(
		'section_style4',
		[
			'label' => __( 'Currency Sign Style', 'additional-addons' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
        $this->add_control(
            'currency_sign_color',
            [
                'label' => __( 'Currency Sign Color Text', 'additional-addons' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .currency-sign' => 'color: {{VALUE}}',
                ],
            ]
        );
        //Layout Currency Sign
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'currency_sign_typography',
                'label' => __( 'Currency Sign Typography', 'additional-addons' ),
                'selector' => '{{WRAPPER}} .currency-sign',
            ]
        );

$this->add_control(
	'epress_currency_sign_margin',
	[
		'label' => __( 'Margin', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .currency-sign div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
	$this->end_controls_section();

        $this->start_controls_section(
            'section_style5',
            [
                'label' => __( 'Decimel Price Style', 'additional-addons' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'decimel_price_color',
            [
                'label' => __( 'Currency Sign Color Text', 'additional-addons' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .decimel-price' => 'color: {{VALUE}}',
                ],
            ]
        );
        //Layout Currency Sign
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'decimel_price_typography',
                'label' => __( 'Currency Sign Typography', 'additional-addons' ),
                'selector' => '{{WRAPPER}} .decimel-price',
            ]
        );

        $this->add_control(
            'epress_decimel_price_margin',
            [
                'label' => __( 'Margin', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .decimel-price div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

	$this->start_controls_section(
		'section_style3',
		[
			'label' => __( 'Month Style', 'additional-addons' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);

	
$this->add_control(
	'epress_duration_margin',
	[
		'label' => __( 'Margin', 'elementpress' ),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => [ 'px', '%', 'em' ],
		'selectors' => [
			'{{WRAPPER}} .duration p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);
	$this->end_controls_section();
}
    /**
	 * Render the Dual Heading And Dual Button widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	//function to show how front end will look like after you change settings in price widget
	//front end live preview.
	protected function render() {
		$settings = $this->get_settings_for_display();
?>
		<?php  
		if ($settings['show_inline']=='yes')  {
			$varis="inline";
		}
		else{
			$varis="block";
		}
		?>
		<div class="epress-price-content epress-align-<?=$settings['cont_align']?>" style="text-align: <?=$settings['cont_align']?>">
		<?php if($settings['show_from']=='yes') : ?>
		<span  class="from" style="position:<?=$settings['position_for_btn']?>"><p style="display:<?=$varis?>"><?=$settings['from']?></p></span>
	    <?php endif;?> 
		<?php if($settings['show_currency_sign']=='yes') :?>
		<span class="currency-sign" style="position:<?=$settings['position_for_btn_price']?>"><div style="display:<?=$varis?>"><?=$settings['currency_sign'];?></div></span>
		<?php endif; ?> 
		<?php if($settings['show_price']=='yes') :?>
		<span class="price" style="position:<?=$settings['position_for_btn_price']?>"><div style="display:<?=$varis?>"><?=$settings['price'];?></div></span>
		<?php endif; ?>
            <?php if($settings['show_price_in_decimel_value']=='yes') :?>
                <span class="decimel-price" style="position:<?=$settings['position_for_btn_price']?>"><div style="display:<?=$varis?>"><?=$settings['decimel_price'];?></div></span>
            <?php endif; ?>
		<?php if($settings['show_duration']=='yes') : ?>

		<span class="duration" style="position: relative;"><p style="display:<?=$varis;?>"><?=$settings['content_seperation'];?><?=$settings['duration'];?></p></span>
		<?php endif; ?>
		</div>
		<?php	
    }
    /**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {
	}
}
?>
