<?php
if(!function_exists('htslider_post_name')){
	function htslider_post_name( $post_type = 'post' ){
	    $options = array();
	    $options['0'] = esc_html__('Select','htslider-pro');
	    $all_post = array( 'posts_per_page' => -1, 'post_type'=> $post_type );
	    $post_terms = get_posts( $all_post );
	    if ( ! empty( $post_terms ) && ! is_wp_error( $post_terms ) ){
	        foreach ( $post_terms as $term ) {
	            $options[ $term->ID ] = $term->post_title;
	        }
	        return $options;
	    }
	}
}
/*
 * Get Post Type
 * return array
 */
if( !function_exists('htslider_get_post_types') ){
    function htslider_get_post_types( $args = [] ) {
       
        $post_type_args = [
            'show_in_nav_menus' => true,
        ];
        if ( ! empty( $args['post_type'] ) ) {
            $post_type_args['name'] = $args['post_type'];
        }
        $_post_types = get_post_types( $post_type_args , 'objects' );

        $post_types  = [];
        foreach ( $_post_types as $post_type => $object ) {
            $post_types[ $post_type ] = $object->label;
        }
        return $post_types;
    }
}

/*
 * Get Taxonomy
 * return array
 */
if( !function_exists('htslider_get_taxonomies') ){
    function htslider_get_taxonomies( $htslider_texonomy = 'category' ){
        $terms = get_terms( array(
            'taxonomy' => $htslider_texonomy,
            'hide_empty' => true,
        ));
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
            foreach ( $terms as $term ) {
                $options[ $term->slug ] = $term->name;
            }
            return $options;
        }
    }
}

?>