<?php

defined( 'ABSPATH' ) || exit; //exit if call directly.

if(!class_exists('ElementPress')):

    final class ElementPress{

		

		const MINIMUM_ELEMENTOR_VERSION = '2.4.0';

		const PACKAGE_TYPE = 'free';

		const version = '0.3';

		const MINIMUM_PHP_VERSION = '5.6';

		

		static function plugin_dir(){

			return trailingslashit(plugin_dir_path( __FILE__ ));

		}

		private static $_instance = null;	

		public static function instance() { //create one instance of class (singleton)			

			if ( is_null( self::$_instance ) ) {

				self::$_instance = new self();

			}

			return self::$_instance;

		}

		static function plugin_url(){

			return trailingslashit(plugin_dir_url( __FILE__ ));

		}

		static function lib_dir(){

			return self::plugin_dir() . 'libs/';

		}

		static function admin_dir(){

			return self::plugin_dir() . 'admin/';

		}

		static function admin_url(){

			return self::plugin_url() . 'admin/';

		}



		static function lib_url(){

			return self::plugin_url() . 'libs/';

		}

		

		static function api_url(){

			return 'https://api.wpmet.com/public/';

		}

		static function module_dir(){

			return self::plugin_dir() . 'modules/';

		}

		static function module_url(){

			return self::plugin_url() . 'modules/';

		}

        public function __construct() {

			

			add_action( 'init', array( $this, 'i18n' ) ); //call i18n (translation domain) on init

			add_action( 'admin_enqueue_scripts', array($this,'load_admin_style' )); //load admin styles

			add_action( 'plugins_loaded', [ $this, 'load_helpers' ] );//call init after plugin is loaded

		}

		

        function i18n() { //translation text domain



			$path =trailingslashit(dirname(plugin_dir_url( __FILE__ )));

			load_plugin_textdomain( 'elementpress', false, $path . '/languages/' ); 

		}

		function load_admin_style(){ //function to load admin style



			$path =trailingslashit(dirname(plugin_dir_url( __FILE__ )));

			

			if(is_admin() && !wp_style_is( 'admin_style', 'enqueued' ) ){ //check if its a admin interface and style is enqueued already



				wp_enqueue_style( 'admin_style',$path  .'elementpress/admin/assets/css/admin_style.css', null, self::version,'all' );

				wp_enqueue_style( 'elementpress-lib-css-admin', $path  .'elementpress/admin/assets/css/framework.css', self::version);	

			}

			if(is_admin() && !wp_script_is( 'admin_js', 'enqueued' ) ){ //check if its a admin interface and script is enqueued already



				wp_enqueue_script( 'admin_js',$path  .'elementpress/admin/assets/js/admin_style.js', null, self::version,'all' );

				wp_enqueue_script( 'elementpress-admin-core-ui',$path  .'elementpress/admin/assets/js/core-ui.min.js', self::version, true );

		

			}					

		}

		 function load_helpers(){

			// Load the main static helper class.

			require_once WP_PLUGIN_DIR. '/elementpress/helpers/notice.php'; //elementor missing notice code

			require_once WP_PLUGIN_DIR. '/elementpress/helpers/utils.php'; // create cpt code



			if (!did_action( 'elementor/loaded' )) { // Check if Elementor installed and activated

				add_action( 'admin_notices', [ $this, 'missing_elementor_notice' ] ); //show message

				return;

			}

			add_action( 'elementor/init', function(){

				

				require_once WP_PLUGIN_DIR. '/elementpress/handler.php';

			}); 

		} 

		

		static function default_modules($package = null){

			$package = ($package != null) ? $package : self::PACKAGE_TYPE;

			$default_list = [

				'header-footer',

				'library',

				'controls',

			];



			return  $default_list;

		}	

		function missing_elementor_notice() { //function to show elementor missing meesage



			if ( file_exists( WP_PLUGIN_DIR . '/elementor/elementor.php' ) ) {

				$btn['label'] = esc_html__('Activate Elementor', 'elementpress');

				$btn['url'] = wp_nonce_url( 'plugins.php?action=activate&plugin=elementor/elementor.php&plugin_status=all&paged=1', 'activate-plugin_elementor/elementor.php' );

			} else {

				$btn['label'] = esc_html__('Install Elementor', 'elementpress');

				$btn['url'] = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );

			}

			\ElementPress\Notice::sendParams(

				[

					

					'type'        => 'error',

					'dismissible' => true,

					'btn'		  => $btn,

					'message'     => sprintf( esc_html__( 'ElementPress requires Elementor version %1$s+, Please', 'elementpress' ), self::MINIMUM_ELEMENTOR_VERSION ),

				]

			);

		}



	};

	ElementPress::instance(); //load one instance of ElementPress class

endif;