<?php 


namespace ElementPress\Modules\Dynamic_Content;





defined( 'ABSPATH' ) || exit;





class Cpt{





    public function __construct() {


        $this->post_type();


        register_deactivation_hook( __FILE__, 'flush_rewrite_rules' );


        register_activation_hook( __FILE__, [$this, 'flush_rewrites'] );   


    }





    public function post_type() {


        


        $labels = array(


            'name'                  => _x( 'Elementor Options', 'Post Type General Name', 'elementpress' ),


            'singular_name'         => _x( 'Elementor Options item', 'Post Type Singular Name', 'elementpress' ),


            'menu_name'             => esc_html__( 'Elementor Options item', 'elementpress' ),


            'name_admin_bar'        => esc_html__( 'Elementor Options item', 'elementpress' ),


            'archives'              => esc_html__( 'Item Archives', 'elementpress' ),


            'attributes'            => esc_html__( 'Item Attributes', 'elementpress' ),


            'parent_item_colon'     => esc_html__( 'Parent Item:', 'elementpress' ),


            'all_items'             => esc_html__( 'All Items', 'elementpress' ),


            'add_new_item'          => esc_html__( 'Add New Item', 'elementpress' ),


            'add_new'               => esc_html__( 'Add New', 'elementpress' ),


            'new_item'              => esc_html__( 'New Item', 'elementpress' ),


            'edit_item'             => esc_html__( 'Edit Item', 'elementpress' ),


            'update_item'           => esc_html__( 'Update Item', 'elementpress' ),


            'view_item'             => esc_html__( 'View Item', 'elementpress' ),


            'view_items'            => esc_html__( 'View Items', 'elementpress' ),


            'search_items'          => esc_html__( 'Search Item', 'elementpress' ),


            'not_found'             => esc_html__( 'Not found', 'elementpress' ),


            'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'elementpress' ),


            'featured_image'        => esc_html__( 'Featured Image', 'elementpress' ),


            'set_featured_image'    => esc_html__( 'Set featured image', 'elementpress' ),


            'remove_featured_image' => esc_html__( 'Remove featured image', 'elementpress' ),


            'use_featured_image'    => esc_html__( 'Use as featured image', 'elementpress' ),


            'insert_into_item'      => esc_html__( 'Insert into item', 'elementpress' ),


            'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'elementpress' ),


            'items_list'            => esc_html__( 'Items list', 'elementpress' ),


            'items_list_navigation' => esc_html__( 'Items list navigation', 'elementpress' ),


            'filter_items_list'     => esc_html__( 'Filter items list', 'elementpress' ),


        );


        $rewrite = array(


            'slug'                  => 'elementpress-content',


            'with_front'            => true,


            'pages'                 => false,


            'feeds'                 => false,


        );


        $args = array(


            'label'                 => esc_html__( 'Elementor Options item', 'elementpress' ),


            'description'           => esc_html__( 'elementpress_content', 'elementpress' ),


            'labels'                => $labels,


            'supports'              => array( 'title', 'editor', 'elementor', 'permalink' ),


            'hierarchical'          => true,


            'public'                => true,


            'show_ui'               => false,


            'show_in_menu'          => false,


            'menu_position'         => 5,


            'show_in_admin_bar'     => false,


            'show_in_nav_menus'     => false,


            'can_export'            => true,


            'has_archive'           => false,


            'publicly_queryable' => true,


            'rewrite'               => $rewrite,


            'query_var' => true,


            'exclude_from_search'   => true,


            'publicly_queryable'    => true,


            'capability_type'       => 'page',


            'show_in_rest'          => true,


            'rest_base'             => 'elementpress-content',


        );


        register_post_type( 'elementpress_content', $args );


    }





    public function flush_rewrites() {


        $this->post_type();


        flush_rewrite_rules();


    }


}





new Cpt();