<?php 
namespace ElementPress\Modules\HeaderFooterBuilder;

defined( 'ABSPATH' ) || exit;

class Cpt{

    public function __construct() {
        $this->post_type(); 

        add_action('admin_menu', [$this, 'cpt_menu']);
        add_filter( 'single_template', [ $this, 'load_canvas_template' ] );
    }

    public function post_type() {
        
		$labels = array(
			'name'               => __( 'Template Options', 'elementpress' ),
			'singular_name'      => __( 'Template Options', 'elementpress' ),
			'menu_name'          => __( 'Template Options', 'elementpress' ),
			'name_admin_bar'     => __( 'Template Options', 'elementpress' ),
			'add_new'            => __( 'Add New', 'elementpress' ),
			'add_new_item'       => __( 'Add New Template', 'elementpress' ),
			'new_item'           => __( 'New Template', 'elementpress' ),
			'edit_item'          => __( 'Edit Template', 'elementpress' ),
			'view_item'          => __( 'View Template', 'elementpress' ),
			'all_items'          => __( 'All Templates', 'elementpress' ),
			'search_items'       => __( 'Search Templates', 'elementpress' ),
			'parent_item_colon'  => __( 'Parent Templates:', 'elementpress' ),
			'not_found'          => __( 'No Templates found.', 'elementpress' ),
			'not_found_in_trash' => __( 'No Templates found in Trash.', 'elementpress' ),
		);

		$args = array(
			'labels'              => $labels,
			'public'              => true,
			'rewrite'             => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'capability_type'     => 'page',
			'hierarchical'        => false,
			'supports'            => array( 'title', 'thumbnail', 'elementor' ),
		);

		register_post_type( 'elementpresstemplate', $args );
    }

    public function cpt_menu(){
        $link_our_new_cpt = 'edit.php?post_type=elementpresstemplate';
        add_submenu_page('elementpress', esc_html__('Template Options', 'elementpress'), esc_html__('Template Options', 'elementpress'), 'manage_options', $link_our_new_cpt);
    }

    function load_canvas_template( $single_template ) {

		global $post;

		if ( 'elementpresstemplate' == $post->post_type ) {

			$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

			if ( file_exists( $elementor_2_0_canvas ) ) {
				return $elementor_2_0_canvas;
			} else {
				return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
			}
		}

		return $single_template;
	}
}

new Cpt();