<?php
namespace ElementPress\Modules\Woocommerce\Conditions;

use ElementPress\Modules\ThemeBuilder as ThemeBuilder;
use ElementPress\Modules\Woocommerce\Init;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Search extends ThemeBuilder\Conditions\Condition_Base {

	public static function get_type() {
		return 'archive';
	}

	public function get_name() {
		return 'product_search';
	}

	public static function get_priority() {
		return 40;
	}

	public function get_label() {
		return __( 'Search Results', 'elementpress' );
	}

	public function check( $args ) {
		return Init::is_product_search();
	}
}
